/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.textmc;

import com.ibm.icu.text.Bidi;
import com.mojang.blaze3d.systems.RenderSystem;
import icyllis.caffeine.cache.Cache;
import icyllis.caffeine.cache.Caffeine;
import icyllis.modernui.ModernUI;
import icyllis.modernui.graphics.font.GlyphManager;
import icyllis.modernui.graphics.font.TexturedGlyph;
import icyllis.modernui.graphics.math.Color3i;
import icyllis.modernui.graphics.textmc.FormattingStyle;
import icyllis.modernui.graphics.textmc.ReorderTextHandler;
import icyllis.modernui.graphics.textmc.TextProcessData;
import icyllis.modernui.graphics.textmc.VanillaTextKey;
import icyllis.modernui.graphics.textmc.pipeline.DigitGlyphRender;
import icyllis.modernui.graphics.textmc.pipeline.GlyphRender;
import icyllis.modernui.graphics.textmc.pipeline.RandomGlyphRender;
import icyllis.modernui.graphics.textmc.pipeline.StandardGlyphRender;
import icyllis.modernui.graphics.textmc.pipeline.TextRenderNode;
import icyllis.modernui.platform.RenderCore;
import java.awt.Font;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class TextLayoutProcessor {
    private static TextLayoutProcessor instance;
    public static int sDefaultFontSize;
    private GlyphManager glyphManager;
    private final Cache<VanillaTextKey, TextRenderNode> stringCache = Caffeine.newBuilder().expireAfterAccess(20L, TimeUnit.SECONDS).build();
    private final VanillaTextKey lookupKey = new VanillaTextKey();
    private final Object lock = new Object();
    private final AtomicReference<TextRenderNode> atomicNode = new AtomicReference();
    private final TextProcessData data = new TextProcessData();
    private final ReorderTextHandler reorder = new ReorderTextHandler();
    private static final Pattern FORMATTING_REMOVE_PATTERN;

    private TextLayoutProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TextLayoutProcessor getInstance() {
        if (instance != null) return instance;
        Class<TextLayoutProcessor> clazz = TextLayoutProcessor.class;
        synchronized (TextLayoutProcessor.class) {
            if (instance != null) return instance;
            instance = new TextLayoutProcessor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Deprecated
    private void cacheDigitGlyphs() {
    }

    public void initRenderer() {
        if (this.glyphManager != null) {
            throw new IllegalStateException("Already initialized");
        }
        this.glyphManager = GlyphManager.getInstance();
        ModernUI.LOGGER.debug(RenderCore.MARKER, "Text engine initialized");
    }

    public void reload() {
        this.glyphManager.reload();
        this.clearLayoutCache();
    }

    public void clearLayoutCache() {
        this.stringCache.invalidateAll();
    }

    public boolean handleSequence(IReorderingProcessor sequence, ReorderTextHandler.IConsumer consumer) {
        return this.reorder.handle(sequence, consumer);
    }

    @Nonnull
    public TextRenderNode lookupVanillaNode(@Nonnull CharSequence string, @Nonnull Style style) {
        this.lookupKey.updateKey(string, style);
        TextRenderNode node = this.stringCache.getIfPresent(this.lookupKey);
        if (node == null) {
            return this.generateVanillaNode(this.lookupKey.copy(), string, style);
        }
        return node;
    }

    @Nullable
    public static TextFormatting fromFormattingCode(char code) {
        int i = "0123456789abcdefklmnor".indexOf(Character.toLowerCase(code));
        return i != -1 ? TextFormatting.values()[i] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private TextRenderNode generateVanillaNode(VanillaTextKey key, @Nonnull CharSequence string, @Nonnull Style style) {
        TextRenderNode node;
        if (!RenderSystem.isOnRenderThread()) {
            Object object = this.lock;
            synchronized (object) {
                Minecraft.func_71410_x().func_213169_a(() -> this.generateVanillaNode(key, string, style)).whenComplete((n, t) -> {
                    this.atomicNode.set((TextRenderNode)n);
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.notify();
                    }
                });
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                TextRenderNode node2 = this.atomicNode.get();
                this.atomicNode.set(null);
                return node2;
            }
        }
        TextProcessData data = this.data;
        char[] text = this.resolveFormattingCodes(data, string, style);
        if (text.length > 0) {
            this.startBidiAnalysis(data, text);
            if (data.allList.isEmpty()) {
                node = TextRenderNode.EMPTY;
            } else {
                this.adjustGlyphIndex(data);
                this.insertColorState(data);
                GlyphRender[] glyphs = data.wrapGlyphs();
                node = new TextRenderNode(glyphs, data.advance, data.hasEffect);
            }
        } else {
            node = TextRenderNode.EMPTY;
        }
        data.release();
        this.stringCache.put(key, node);
        return node;
    }

    @Nonnull
    @Deprecated
    private Entry getOrCacheString(@Nonnull String str) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        char[] text = str.toCharArray();
        Entry entry = new Entry();
        int length = this.extractFormattingCodes(entry, str, text);
        ArrayList<Glyph> glyphList = new ArrayList<Glyph>();
        entry.advance = this.layoutBidiString(glyphList, text, 0, length, entry.codes);
        entry.glyphs = new Glyph[glyphList.size()];
        entry.glyphs = glyphList.toArray(entry.glyphs);
        Arrays.sort(entry.glyphs);
        boolean colorIndex = false;
        boolean shift = false;
        for (int glyphIndex = 0; glyphIndex < entry.glyphs.length; ++glyphIndex) {
            Glyph glyph = entry.glyphs[glyphIndex];
        }
        Key key = new Key();
        key.str = str;
        return entry;
    }

    @Nonnull
    private char[] resolveFormattingCodes(@Nonnull TextProcessData data, @Nonnull CharSequence string, @Nonnull Style defStyle) {
        int shift = 0;
        Style style = defStyle;
        data.codes.add(new FormattingStyle(0, 0, style));
        int limit = string.length() - 1;
        for (int next = 0; next < limit; ++next) {
            if (string.charAt(next) != '\u00a7') continue;
            TextFormatting formatting = TextLayoutProcessor.fromFormattingCode(string.charAt(next + 1));
            if (formatting != null) {
                style = formatting == TextFormatting.RESET ? defStyle : style.func_240723_c_(formatting);
            }
            data.codes.add(new FormattingStyle(next, next - shift, style));
            ++next;
            shift += 2;
        }
        return FORMATTING_REMOVE_PATTERN.matcher(string).replaceAll("").toCharArray();
    }

    private void startBidiAnalysis(TextProcessData data, @Nonnull char[] text) {
        if (Bidi.requiresBidi((char[])text, (int)0, (int)text.length)) {
            Bidi bidi = new Bidi(text, 0, null, 0, text.length, 126);
            if (bidi.isRightToLeft()) {
                this.layoutStyle(data, text, 0, text.length, 1);
            } else {
                int runCount = bidi.getRunCount();
                byte[] levels = new byte[runCount];
                Object[] ranges = new Integer[runCount];
                for (int index = 0; index < runCount; ++index) {
                    levels[index] = (byte)bidi.getRunLevel(index);
                    ranges[index] = index;
                }
                Bidi.reorderVisually((byte[])levels, (int)0, (Object[])ranges, (int)0, (int)runCount);
                for (int visualIndex = 0; visualIndex < runCount; ++visualIndex) {
                    int logicalIndex = (Integer)ranges[visualIndex];
                    int flag = (bidi.getRunLevel(logicalIndex) & 1) == 1 ? 1 : 0;
                    this.layoutStyle(data, text, bidi.getRunStart(logicalIndex), bidi.getRunLimit(logicalIndex), flag);
                }
            }
        } else {
            this.layoutStyle(data, text, 0, text.length, 0);
        }
    }

    private void layoutStyle(@Nonnull TextProcessData data, char[] text, int start, int limit, int flag) {
        float lastAdvance = data.advance;
        if (flag == 1) {
            data.layoutRight = lastAdvance;
        }
        List<FormattingStyle> codes = data.codes;
        int codeIndex = data.codeIndex;
        while (start < limit) {
            int next = limit;
            while (codeIndex < codes.size() - 1 && codes.get((int)codeIndex).stripIndex == codes.get((int)(codeIndex + 1)).stripIndex) {
                ++codeIndex;
            }
            FormattingStyle style = codes.get(codeIndex);
            while (codeIndex < codes.size() - 1) {
                if (codes.get(++codeIndex).layoutStyleEquals(style)) continue;
                next = codes.get((int)codeIndex).stripIndex;
                break;
            }
            this.layoutText(data, text, start, next, flag, style);
            start = next;
        }
        data.codeIndex = codeIndex;
        if (flag == 1) {
            data.finishStyleLayout(data.advance - lastAdvance);
        } else {
            data.finishStyleLayout(0.0f);
        }
    }

    private void layoutText(TextProcessData data, char[] text, int start, int limit, int flag, @Nonnull FormattingStyle style) {
        byte effect;
        for (int i = start; i < limit; ++i) {
            if (text[i] > '9' || text[i] < '0') continue;
            text[i] = 48;
        }
        Font font = null;
        int last = start;
        if (style.isUnderline()) {
            effect = style.isStrikethrough() ? (byte)3 : 1;
            data.hasEffect = true;
        } else if (style.isStrikethrough()) {
            effect = 2;
            data.hasEffect = true;
        } else {
            effect = 0;
        }
        for (int next = start; next < limit; ++next) {
            boolean layout;
            int codePoint;
            int c1 = text[next];
            if (Character.isHighSurrogate((char)c1) && next + 1 < limit) {
                char c2 = text[next + 1];
                if (Character.isLowSurrogate(c2)) {
                    codePoint = Character.toCodePoint((char)c1, c2);
                    ++next;
                } else {
                    codePoint = c1;
                }
            } else {
                codePoint = c1;
            }
            if (font == null) {
                font = this.glyphManager.lookupFont(codePoint);
                continue;
            }
            Font f = this.glyphManager.lookupFont(codePoint);
            boolean bl = layout = font != f && codePoint != 32;
            if (!layout) continue;
            this.layoutFont(data, text, last, next, flag, this.glyphManager.deriveFont(font, style.getFontStyle(), sDefaultFontSize * GlyphManager.sResolutionLevel), style.isObfuscated(), effect);
            font = f;
            last = next;
        }
        if (font != null) {
            this.layoutFont(data, text, last, limit, flag, this.glyphManager.deriveFont(font, style.getFontStyle(), sDefaultFontSize * GlyphManager.sResolutionLevel), style.isObfuscated(), effect);
        }
    }

    private void layoutFont(TextProcessData data, char[] text, int start, int limit, int flag, Font font, boolean random, byte effect) {
        if (random) {
            this.layoutRandom(data, text, start, limit, flag, font, effect);
        } else {
            GlyphVector vector = this.glyphManager.layoutGlyphVector(font, text, start, limit, flag);
            int num = vector.getNumGlyphs();
            TexturedGlyph[] digits = this.glyphManager.lookupDigits(font);
            float factor = this.glyphManager.getResolutionFactor();
            for (int i = 0; i < num; ++i) {
                if (vector.getGlyphMetrics(i).getAdvanceX() == 0.0f && vector.getGlyphMetrics(i).getBounds2D().getWidth() == 0.0) continue;
                int stripIndex = vector.getGlyphCharIndex(i) + start;
                Point2D point = vector.getGlyphPosition(i);
                float offset = (float)(point.getX() / (double)factor);
                offset = flag == 1 ? (offset += data.layoutRight) : (offset += data.advance);
                char o = text[stripIndex];
                if (o == '0') {
                    data.minimalList.add(new DigitGlyphRender(digits, effect, stripIndex, offset));
                    continue;
                }
                int glyphCode = vector.getGlyphCode(i);
                TexturedGlyph glyph = this.glyphManager.lookupGlyph(font, glyphCode);
                data.minimalList.add(new StandardGlyphRender(glyph, effect, stripIndex, offset));
            }
            float totalAdvance = (float)(vector.getGlyphPosition(num).getX() / (double)factor);
            data.advance += totalAdvance;
            if (flag == 1) {
                data.finishFontLayout(-totalAdvance);
                data.layoutRight -= totalAdvance;
            } else {
                data.finishFontLayout(0.0f);
            }
        }
    }

    private void layoutEmoji(TextProcessData data, int codePoint, int start, int flag) {
        float offset = flag == 1 ? data.layoutRight : data.advance;
        data.minimalList.add(new StandardGlyphRender(this.glyphManager.lookupEmoji(codePoint), 0, start, offset));
        data.advance += (offset += 12.0f);
        if (flag == 1) {
            data.finishFontLayout(-offset);
            data.layoutRight -= offset;
        } else {
            data.finishFontLayout(0.0f);
        }
    }

    private void layoutRandom(TextProcessData data, char[] text, int start, int limit, int flag, Font font, byte effect) {
        TexturedGlyph[] digits = this.glyphManager.lookupDigits(font);
        float stdAdv = digits[0].getAdvance();
        float offset = flag == 1 ? data.layoutRight : data.advance;
        for (int i = start; i < limit; ++i) {
            char c2;
            data.minimalList.add(new RandomGlyphRender(digits, effect, start + i, offset));
            offset += stdAdv;
            char c1 = text[i];
            if (i + 1 >= limit || !Character.isHighSurrogate(c1) || !Character.isLowSurrogate(c2 = text[i + 1])) continue;
            ++i;
        }
        data.advance += offset;
        if (flag == 1) {
            data.finishFontLayout(-offset);
            data.layoutRight -= offset;
        } else {
            data.finishFontLayout(0.0f);
        }
    }

    private void adjustGlyphIndex(@Nonnull TextProcessData data) {
        data.allList.sort(Comparator.comparingInt(g2 -> g2.stringIndex));
        List<FormattingStyle> codes = data.codes;
        List<GlyphRender> glyphs = data.allList;
        int codeIndex = 1;
        int shift = 0;
        for (GlyphRender glyph : glyphs) {
            while (codeIndex < codes.size() && glyph.stringIndex + shift >= codes.get((int)codeIndex).stringIndex) {
                shift += 2;
                ++codeIndex;
            }
            glyph.stringIndex += shift;
        }
    }

    private void insertColorState(@Nonnull TextProcessData data) {
        int codeIndex;
        List<FormattingStyle> codes = data.codes;
        List<GlyphRender> glyphs = data.allList;
        for (codeIndex = 0; codeIndex < codes.size() - 1 && codes.get((int)codeIndex).stripIndex == codes.get((int)(codeIndex + 1)).stripIndex; ++codeIndex) {
        }
        int color = codes.get(codeIndex).getColor();
        if (color != -1) {
            glyphs.get((int)0).color = color;
        }
        if (++codeIndex < codes.size()) {
            for (int glyphIndex = 1; glyphIndex < glyphs.size(); ++glyphIndex) {
                GlyphRender glyph = glyphs.get(glyphIndex);
                if (codeIndex >= codes.size() || glyph.stringIndex <= codes.get((int)codeIndex).stringIndex) continue;
                while (codeIndex < codes.size() - 1 && codes.get((int)codeIndex).stripIndex == codes.get((int)(codeIndex + 1)).stripIndex) {
                    ++codeIndex;
                }
                FormattingStyle s2 = codes.get(codeIndex);
                if (s2.getColor() != color) {
                    glyph.color = color = s2.getColor();
                }
                ++codeIndex;
            }
        }
    }

    @Deprecated
    private int extractFormattingCodes(Entry cacheEntry, @Nonnull String str, char[] text) {
        int next;
        ArrayList<FormattingCode> codeList = new ArrayList<FormattingCode>();
        int start = 0;
        int shift = 0;
        int fontStyle = 0;
        int renderStyle = 0;
        int colorCode = -1;
        while ((next = str.indexOf(167, start)) != -1 && next + 1 < str.length()) {
            System.arraycopy(text, next - shift + 2, text, next - shift, text.length - next - 2);
            int code = "0123456789abcdefklmnor".indexOf(Character.toLowerCase(str.charAt(next + 1)));
            switch (code) {
                case 16: {
                    break;
                }
                case 17: {
                    fontStyle = (byte)(fontStyle | 1);
                    break;
                }
                case 18: {
                    renderStyle = (byte)(renderStyle | 2);
                    cacheEntry.needExtraRender = true;
                    break;
                }
                case 19: {
                    renderStyle = (byte)(renderStyle | 1);
                    cacheEntry.needExtraRender = true;
                    break;
                }
                case 20: {
                    fontStyle = (byte)(fontStyle | 2);
                    break;
                }
                case 21: {
                    fontStyle = 0;
                    renderStyle = 0;
                    colorCode = -1;
                    break;
                }
                default: {
                    if (code < 0) break;
                    colorCode = (byte)code;
                }
            }
            FormattingCode formatting = new FormattingCode();
            formatting.stringIndex = next;
            formatting.stripIndex = next - shift;
            formatting.color = Color3i.fromFormattingCode(colorCode);
            formatting.fontStyle = (byte)fontStyle;
            formatting.renderEffect = (byte)renderStyle;
            codeList.add(formatting);
            start = next + 2;
            shift += 2;
        }
        cacheEntry.codes = codeList.toArray(new FormattingCode[0]);
        return text.length - shift;
    }

    @Deprecated
    private float layoutBidiString(List<Glyph> glyphList, char[] text, int start, int limit, FormattingCode[] codes) {
        float advance = 0.0f;
        if (Bidi.requiresBidi((char[])text, (int)start, (int)limit)) {
            Bidi bidi = new Bidi(text, start, null, 0, limit - start, 126);
            if (bidi.isRightToLeft()) {
                return this.layoutStyle(glyphList, text, start, limit, 1, advance, codes);
            }
            int runCount = bidi.getRunCount();
            byte[] levels = new byte[runCount];
            Object[] ranges = new Integer[runCount];
            for (int index = 0; index < runCount; ++index) {
                levels[index] = (byte)bidi.getRunLevel(index);
                ranges[index] = index;
            }
            Bidi.reorderVisually((byte[])levels, (int)0, (Object[])ranges, (int)0, (int)runCount);
            for (int visualIndex = 0; visualIndex < runCount; ++visualIndex) {
                int logicalIndex = (Integer)ranges[visualIndex];
                int layoutFlag = (bidi.getRunLevel(logicalIndex) & 1) == 1 ? 1 : 0;
                advance = this.layoutStyle(glyphList, text, start + bidi.getRunStart(logicalIndex), start + bidi.getRunLimit(logicalIndex), layoutFlag, advance, codes);
            }
            return advance;
        }
        return this.layoutStyle(glyphList, text, start, limit, 0, advance, codes);
    }

    @Deprecated
    private float layoutStyle(List<Glyph> glyphList, char[] text, int start, int limit, int layoutFlags, float advance, FormattingCode[] codes) {
        boolean currentFontStyle = false;
        return advance;
    }

    @Deprecated
    private float layoutString(List<Glyph> glyphList, char[] text, int start, int limit, int layoutFlags, float advance, int style) {
        while (start < limit) {
            int next = 0;
            if (next == start) {
                // empty if block
            }
            start = ++next;
        }
        return advance;
    }

    @Deprecated
    private float layoutFont(List<Glyph> glyphList, char[] text, int start, int limit, int layoutFlags, float advance, Font font) {
        Object vector = null;
        Object glyph = null;
        boolean numGlyphs = true;
        return advance;
    }

    static {
        FORMATTING_REMOVE_PATTERN = Pattern.compile("\u00a7.");
    }

    @Deprecated
    public static class Key {
        public String str;

        public int hashCode() {
            int code = 0;
            int length = this.str.length();
            boolean colorCode = false;
            for (int index = 0; index < length; ++index) {
                int c = this.str.charAt(index);
                if (c >= 48 && c <= 57 && !colorCode) {
                    c = 48;
                }
                code = code * 31 + c;
                colorCode = c == 167;
            }
            return code;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            String other = o.toString();
            int length = this.str.length();
            if (length != other.length()) {
                return false;
            }
            boolean colorCode = false;
            for (int index = 0; index < length; ++index) {
                char c2;
                char c1 = this.str.charAt(index);
                if (c1 != (c2 = other.charAt(index)) && (c1 < '0' || c1 > '9' || c2 < '0' || c2 > '9' || colorCode)) {
                    return false;
                }
                colorCode = c1 == '\u00a7';
            }
            return true;
        }

        public String toString() {
            return this.str;
        }
    }

    @Deprecated
    public static class Glyph
    implements Comparable<Glyph> {
        int stringIndex;
        int texture;
        int x;
        int y;
        float advance;

        @Override
        public int compareTo(Glyph o) {
            return Integer.compare(this.stringIndex, o.stringIndex);
        }
    }

    @Deprecated
    public static class FormattingCode
    implements Comparable<Integer> {
        public static final byte UNDERLINE = 1;
        public static final byte STRIKETHROUGH = 2;
        public int stringIndex;
        public int stripIndex;
        public byte fontStyle;
        @Nullable
        public Color3i color;
        public byte renderEffect;

        @Override
        public int compareTo(@Nonnull Integer i) {
            return Integer.compare(this.stringIndex, i);
        }
    }

    @Deprecated
    public static class Entry {
        public WeakReference<Key> keyRef;
        public float advance;
        public Glyph[] glyphs;
        public FormattingCode[] codes;
        public boolean needExtraRender;
    }
}

